IF EXISTS( SELECT * FROM SYS.procedures WHERE NAME = 'P_MEDIAF_LIBERAR_PRODUTO_CALCULO' )
    BEGIN
        DROP PROCEDURE P_MEDIAF_LIBERAR_PRODUTO_CALCULO;
    END;
GO

/****** Object:  StoredProcedure [dbo].[P_MEDIAF_LIBERAR_PRODUTO_CALCULO]    Script Date: 03/09/2014 11:32:55 ******/
SET ANSI_NULLS ON;
GO

SET QUOTED_IDENTIFIER ON;
GO

--Liberar produtos para recalculo de media F, apos 3 meses de vendas fechados a partir 
--de seu nascimento na loja (nascimento refere-se a primeira de entrada do produto na loja)
--EXECUTE P_MEDIAF_LIBERAR_PRODUTO_CALCULO

CREATE PROCEDURE [dbo].[P_MEDIAF_LIBERAR_PRODUTO_CALCULO]
AS
BEGIN
SET NOCOUNT ON;
    Declare @ConsideraMetadeMesFechado Tinyint =0;
	
	Set  @ConsideraMetadeMesFechado =isnull((Select VALOR From Prc_Emp_config where cd_chave ='MEDIAF_CONSID_MEIO_MES_COMO_MES_FECHADO' AND cd_emp=1),0);

	CREATE TABLE #PROD_MEDIA_F_LIBERADA
								(CD_EMP                 INT
								, CD_FILIAL              INT
								, CD_PROD                INT 
								, QTDE_MES_VENDA_FECHADO INT);

 
		DECLARE @Loja INT;

		DECLARE cMediafLiberar CURSOR FAST_FORWARD
		FOR SELECT  CD_FILIAL
			FROM  PRC_FILIAL
			WHERE STS_FILIAL=0
			ORDER BY  CD_FILIAL;


		OPEN cMediafLiberar;
		FETCH NEXT FROM cMediafLiberar INTO  @Loja;

		WHILE @@FETCH_STATUS = 0
			BEGIN
				PRINT 'Procesando lj ' + CONVERT(VARCHAR, @Loja);
				INSERT INTO #PROD_MEDIA_F_LIBERADA
				SELECT 
					  C.CD_EMP
					, C.CD_FILIAL
					, C.CD_PROD 
					, dbo.F_EST_PROD_CPL_NASC_RET_QTDE_MES_FECHADO(dt_nasc, @ConsideraMetadeMesFechado)  QTDE_MES_VENDA_FECHADO
				FROM 
					EST_PROD_CPL_NASC C
					JOIN EST_PROD P ON
					C.CD_EMP =P.CD_EMP AND
					C.CD_PROD =P.CD_PROD
				where
					c.CD_EMP=1
					AND P.STS_PROD <> 1
					AND c.CD_FILIAL=@Loja ;
					 

				--SELECT * FROM #PROD_MEDIA_F_LIBERADA WHERE CD_PROD=2231  

				UPDATE EST_PROD_CPL_NASC
				  SET 
					  MEDIA_F_LIBERADA = CASE WHEN MdLib.QTDE_MES_VENDA_FECHADO >= 3 THEN 1
											 ELSE 0
										 END
					, QTDE_MES_VENDA_FECHADO = MdLib.QTDE_MES_VENDA_FECHADO
				FROM EST_PROD_CPL_NASC
					 INNER JOIN #PROD_MEDIA_F_LIBERADA MdLib ON EST_PROD_CPL_NASC.CD_EMP = MdLib.CD_EMP
																AND EST_PROD_CPL_NASC.CD_FILIAL = MdLib.CD_FILIAL
																AND EST_PROD_CPL_NASC.CD_PROD = MdLib.CD_PROD
				where
						EST_PROD_CPL_NASC.CD_EMP=1
					AND EST_PROD_CPL_NASC.CD_FILIAL=@Loja;

				TRUNCATE TABLE #PROD_MEDIA_F_LIBERADA;
				FETCH NEXT FROM cMediafLiberar INTO  @Loja;

			END;

		CLOSE cMediafLiberar;
		DEALLOCATE cMediafLiberar;

END;
GO